<?php

namespace Keosu\CoreBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class FormEvent extends Event
{
	private $form;
	private $request;
	private $response;

	public function __construct(FormInterface $form, Request $request)
	{
		$this->form = $form;
		$this->request = $request;
	}

	/**
	 * @return FormInterface
	 */
	public function getForm()
	{
		return $this->form;
	}

	/**
	 * @return Request
	 */
	public function getRequest()
	{
		return $this->request;
	}

	public function setResponse(Response $response)
	{
		$this->response = $response;
	}

	/**
	 * @return Response|null
	 */
	public function getResponse()
	{
		return $this->response;
	}
}
