/*
 * moving subnavigation bar snapping to top on scroll
 * http://stackoverflow.com/questions/9179708/replicating-bootstraps-main-nav-and-subnav
 * http://stackoverflow.com/questions/10318163/subnav-bar-collapsed-with-twitter-bootstrap
 */

 $(document).scroll(function(){
     //check for .subnav
     if ($('.subnav').length) {
       // If has not activated (has no attribute "data-top"
       if (!$('.subnav').attr('data-top')) {
           // If already fixed, then do nothing
           if ($('.subnav').hasClass('subnav-fixed')) {
               return;
           }
           // Remember top position
           var offset = $('.subnav').offset();
           $('.subnav').attr('data-top', offset.top);
       }
      
       if ($('.subnav').attr('data-top') - $('.subnav').outerHeight() <= $(this).scrollTop()){
           $('.subnav').addClass('subnav-fixed');
       } else{
           $('.subnav').removeClass('subnav-fixed');
       }
     }
 });
 /*
//This snipplet is from bootstrap docs, currently i assume both not to work perfectly :( 
!function($) {
    "use strict";

    $(function() {
        // fix sub nav on scroll
        var $win = $(window), $nav = $('.subnav'), navTop = $('.subnav').length
                && $('.subnav').offset().top - 40, isFixed = 0;

        processScroll();

        // hack sad times - holdover until rewrite for 2.1
        $nav.on('click', function() {
            if (!isFixed)
                setTimeout(function() {
                    $win.scrollTop($win.scrollTop() - 47);
                }, 10);
        });

        $win.on('scroll', processScroll);

        function processScroll() {
            var scrollTop = $win.scrollTop();
            if (scrollTop >= navTop && !isFixed) {
                isFixed = 1;
                $nav.addClass('subnav-fixed');
            } else if (scrollTop <= navTop && isFixed) {
                isFixed = 0;
                $nav.removeClass('subnav-fixed');
            }
        }

    });

}(window.jQuery);*/