var importedPackages = ["keosu-base","angularJs","jQuery","keosu-push","keosu-around-me","keosu-comments"];
var app = angular.module('keosuApp', ['angular-chrono', 'angularSpinner','angular-carousel','ngSanitize', 'ngTouch', 'ngRoute','angular-inview','LocalStorageModule','CacheManagerModule']);

app.controller('main_Controller', function($http, $rootScope) {
		$http.get('data/globalParam.json').success( function (data) {
			$rootScope.appName = data.name;
			 // $rootScope;previousButton : used to display a return button in the header
			 // to show the button you should set the value true to the boolean
			 // when you click on the button, the method $rootScope.prev is called 
			$rootScope.previousButton = false;
		});
		//alert("Connection :"+navigator.connection.type);
        $rootScope.offline=false;
		document.addEventListener("offline",
				function(){
                    $rootScope.offline=true;
					alert("Network unreachable. The page will be reload soon as possible.");
					document.addEventListener("online",function(){
                        $rootScope.offline=false;
						alert("Reconnection !");
						document.removeEventListener("online",function(){},false);
						location.reload();
				}, false);
		}, false);
});

// Don't forget to take a look at exportListener.php before edit this file
app.directive('keosuPush', function(){
	return {
		restrict : 'E',
		templateUrl : 'plugins/keosu-push/templates/default.html',
		controller : ['$scope','$http', function ($scope, $http) {

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

			$scope.init = function() {
				console.log('function init');
				document.addEventListener('deviceready', function() {
					console.log('i\'m ready');
					// if push notification is enabled
					pushNotification = window.plugins.pushNotification;
					if(typeof(device) != 'undefined' && typeof(pushNotificationData) != 'undefined') {
						$http.get('data/globalParam.json').success(function(data) {
							$scope.host = data.host;
							if(device.platform == 'android' || device.platform == 'Android' || device.platform == "amazon-fireos") {
								$scope.androidPush();
							} else {
								$scope.applePush();
							}
						});
					}
				},false);
			};

			////////////////////////
			// Android part
			////////////////////////
			$scope.androidPush = function() {
				appAndroid = {
					successHandler: function(result) {
						console.log("Push success : "+result);
					},
					errorHandler: function(error) {
						console.log("Push error : "+error);
					},
					onNotification: function(e) {
						switch( e.event ) {
							case 'registered':
							if ( e.regid.length > 0 ) {
								$http.post($scope.host+'service/push/plugin/addDevice/2','token='+e.regid);
							}
							break;

							case 'message':
							// this is the actual push notification. its format depends on the data model from the push server
							console.log('message = '+e.message+' msgcnt = '+e.msgcnt);
							break;

							case 'error':
							console.log('GCM error = '+e.msg);
							break;

							default:
							console.log('An unknown GCM event has occurred');
							break;
						}
					}
				};

				pushNotification.register(
					appAndroid.successHandler,
					appAndroid.errorHandler,
					{'senderID':pushNotificationData.senderID+"",'ecb': "appAndroid.onNotification" }
				);
			};
		
			/////////////////////
			// Apple part
			/////////////////////
			$scope.applePush = function() {
				console.log('I\'m an Iphone...');
				appPushNotification = {
					tokenHandler: function(result) {
						console.log('iphone id');
						console.log(result);
						if( result.length > 0 ) {
							$http.post($scope.host+'service/push/plugin/addDevice/1','token='+result);
						}
					},
					errorHandler: function(error){console.log('the eoor is '+error)},
					onNotificationAPN: function(event) {
						if( event.alert )
							navigator.notification.alert(event.alert);
						if( event.sound ) {
							var snd = new Media(event.sound);
							snd.play();
						}
						if( event.badge )
							pushNotification.setApplicationIconBadgeNumber(successHandler, errorHandler, event.badge);
					}
				};

				pushNotification.register(
					appPushNotification.tokenHandler,
					appPushNotification.errorHandler,
					{
						'badge' : 'true',
						'sound' : 'true',
						'alert' : 'true',
						'ecb'   : 'appPushNotification.onNotificationAPN'
					}
				);
			};

		}]
	};
});


app.config(function($routeProvider,$locationProvider){
	$routeProvider.when("/Page/:pageName",{
		templateUrl: function(params) {
			return params.pageName+".html";
		}
	})
	.otherwise({redirectTo:"/Page/1"});
});app.directive('keosuComments', function(){
	return {
		restrict : 'E',
		scope : {
			objectId: '=objectId',
			objectName: '=objectName',
			enableComments: '=enableComments'
		},
		templateUrl : 'plugins/keosu-comments/templates/default.html',
		controller : ['$scope','$http', function ($scope, $http) {
		
			$scope.$watch('objectId', function() {
				$scope.myinit();
        	});
			
			$scope.myinit = function() {
				$http.get('data/globalParam.json').success(function(data){
					$scope.host = data.host;
					$scope.commentListAction();
				});
			}

			$scope.commentListAction = function() {
				if ($scope.objectId) {
					$http.get($scope.host+'service/gadget/comment/'+$scope.objectName+'/'+$scope.objectId).success(function(data){
						$scope.comments = data.comments;
						$scope.connect = data.connect;
					});
				}
			};

			$scope.commentAddAction = function() {
				var data = "message="+$scope.messageComment;
				$scope.messageComment = "";
				if (data != "message=") {//check if the commentaire is not empty
					$http.post($scope.host+'service/gadget/comment/'+$scope.objectName+'/'+$scope.objectId,data).success(function(data){
						$scope.comments = data.comments;
						$scope.connect = data.connect;
					});
				};
			};
		}]
	};
});
/************************************************************************
	Keosu is an open source CMS for mobile app
	Copyright (C) 2013  Vincent Le Borgne

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ************************************************************************/

//Main controller
app.controller('keosu-around-meController', function ($rootScope, $scope, $http, $sce, usSpinnerService, cacheManagerService) {
	//Functions
	$scope.parts=function(isList, isMap, $scope) {
		$scope.isList = isList;
		$scope.isMap = isMap;
	}
	//Init google gadget
	$scope.initialize=function() {
		var mapOptions = {
				center: new google.maps.LatLng(47.21677,-1.553307),
				zoom: 8,
				mapTypeId: google.maps.MapTypeId.ROADMAP
		};
		var map = new google.maps.Map(document.getElementById("map_canvas"),mapOptions);
		return map;
	}
	
	$scope.open = function (page) {
		$rootScope.previousButton = true;
		$scope.distance = page.distance;
		usSpinnerService.spin('spinner'); // While loading, there will be a spinner
		cacheManagerService.get($scope.param.host + 'service/gadget/aroundme/view/'
				+ page.id + '/json').success(function (data){
					usSpinnerService.stop('spinner');
					//Init map
					$scope.myMap = data[0];
					$scope.myMap.description = $sce.trustAsHtml(decodedContent(data[0].description));
					$scope.myMap.name = $('<div/>').html(data[0].name).text();
					
					var map=$scope.initialize();
					map.setZoom($scope.param.gadgetParam.zoom);
					google.maps.event.trigger($("#map_canvas")[0], 'resize');
					var latitudeAndLongitude = new google.maps.LatLng(data[0].lat,data[0].lng);
					map.setCenter(latitudeAndLongitude);
					
					//Init my marquer
					$scope.myMarker.setMap(map);
					
					//Init POI marker
					markerOne = new google.maps.Marker({
						position: latitudeAndLongitude,
						title: $scope.myMap.name,
						map: map
					});
					
					//Trace line between two point
					var newLineCoordinates = [$scope.myMarker.position,latitudeAndLongitude];
					var newLine = new google.maps.Polyline({
						  path: newLineCoordinates,        
						  strokeColor: "#FF0000",
						  strokeOpacity: 1.0,
						  strokeWeight: 2
						});
					newLine.setMap(map);
					
					window.setTimeout(function(){
                        google.maps.event.trigger($("#map_canvas")[0], 'resize');
                        map.setCenter(latitudeAndLongitude);
                        },100);

					$scope.parts(false, true, $scope);
				});
	};
	$rootScope.previous = function () {
		$rootScope.previousButton = false;
		$scope.parts(true, false, $scope);
	};
	
	$scope.init = function (params) {
			$rootScope.previousButton = false;
			$scope.parts(true, false, $scope);
			$scope.initialize();
			usSpinnerService.spin('spinner'); // While loading, there will be a spinner
			$scope.param = params;
	
			var onGpsSuccess = function(position) {
				cacheManagerService.get($scope.param.host + 'service/gadget/aroundme/' + $scope.param.gadgetId +'/'
						+ position.coords.latitude + '/'
						+ position.coords.longitude + '/0/' + '10' + '/json').success(function (data) {
							usSpinnerService.stop('spinner');
							$tmp = [];		
							for (i = 0; i < data.data.length; i++) {
								$tmp[i] = data.data[i];
								$tmp[i].title = $('<div/>').html(data.data[i].title).text();
							}
							$scope.pages = $tmp;
							usSpinnerService.stop('spinner');
						});
			};
			function onGpsError(error) {
				alert('Impossible de vous localiser.');
			}	
			cacheManagerService.getLocation($scope.param.host + 'service/gadget/aroundme/'+$scope.param.gadgetId+'/location')
			.success(function (position) {
				var pinColor = "00EE00";
			    var pinImage = "http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|" + pinColor;
			    var latitudeAndLongitude = new google.maps.LatLng(position.coords.latitude,position.coords.longitude);
				$scope.myMarker = new google.maps.Marker({
					position: latitudeAndLongitude,
				});
				$scope.myMarker.setIcon(({
				      url: pinImage,
				    }));
				onGpsSuccess(position);
			});
		}	
});
