/* ============================================================
 * mopabootstrap-collection.js v3.0.0
 * http://bootstrap.mohrenweiserpartner.de/mopa/bootstrap/forms/extended
 * ============================================================
 * Copyright 2012 Mohrenweiser & Partner
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============================================================ */

!function ($) {

    "use strict";

   /* Collection PUBLIC CLASS DEFINITION
    * ============================== */

    var Collection = function (element, options) {
        this.$element = $(element);
        this.options = $.extend({}, $.fn.collection.defaults, options);

        // This must work with "collections" inside "collections", and should
        // select its children, and not the "collection" inside children.
        var $collection = $('div' + this.options.collection_id);
        var itemSelector = $collection.attr('data-widget-controls') === 'true'
            ? 'div' + this.options.collection_id + ' > .collection-items > .collection-item'
            : 'div' + this.options.collection_id + ' > .collection-item'
        ;

        // Indexes must be different for every Collection
        if(typeof this.options.index === 'undefined') {
            this.options.index = {};
        }

        this.options.index[this.options.collection_id] = this.options.initial_size;
    };

    Collection.prototype = {
        constructor: Collection,
        add: function () {
            // this leads to overriding items
            this.options.index[this.options.collection_id] = this.options.index[this.options.collection_id] + 1;
            var index = this.options.index[this.options.collection_id];
            if ($.isFunction(this.options.addcheckfunc) && !this.options.addcheckfunc()) {
                if ($.isFunction(this.options.addfailedfunc)) {
                    this.options.addfailedfunc();
                }
                return;
            }
            this.addPrototype(index);
        },
        addPrototype: function(index) {
            var $collection = $(this.options.collection_id);
            var prototype_name = $collection.attr('data-prototype-name');

            // Just in case it doesnt get it
            if(typeof prototype_name === 'undefined'){
                prototype_name = '__name__';
            }
            var replace_pattern = new RegExp(prototype_name, 'g');

            var rowContent = $collection.attr('data-prototype').replace(replace_pattern, index);
            var row = $(rowContent);
            
            $collection.children('.collection-items').append(row);
            
            $collection.triggerHandler('add.mopa-collection-item', [row]);
        },
        remove: function () {
                if (this.$element.parents('.collection-item').length !== 0){
                    var row = this.$element.closest('.collection-item');
                    row.remove();
                    $(this.options.collection_id).triggerHandler('remove.mopa-collection-item', [row]);
                }
        }

    };


 /* COLLECTION PLUGIN DEFINITION
  * ======================== */

  $.fn.collection = function ( option ) {
      return this.each(function () {
          var $this = $(this),
            collection_id = $this.data('collection-add-btn'),
            data = $this.data('collection'),
            options = typeof option == 'object' ? option : {};
          if(collection_id){
              options.collection_id = collection_id;
          }
          else if($this.closest(".form-group").attr('id')){
        	  options.collection_id = '#'+$this.closest(".form-group").attr('id');
          }
          else{
        	  options.collection_id = this.id.length === 0 ? '' : '#' + this.id;
          }
          if (!data){
              options.initial_size = $this.find('.collection-items').children().length;
              $this.data('collection', (data = new Collection(this, options)));
          }
          if (option == 'add') {
              data.add();
          }
          if (option == 'remove'){
              data.remove();
          }
      });
  };

  $.fn.collection.defaults = {
    collection_id: null,
    initial_size: 0,
    addcheckfunc: false,
    addfailedfunc: false
  };

  $.fn.collection.Constructor = Collection;


 /* COLLECTION DATA-API
  * =============== */

  $(function () {
      $('body').on('click.collection.data-api', '[data-collection-add-btn]', function ( e ) {
        var $btn = $(e.target);
        if (!$btn.hasClass('btn')){
            $btn = $btn.closest('.btn');
        }
        $btn.collection('add');
        e.preventDefault();
      });
      $('body').on('click.collection.data-api', '[data-collection-remove-btn]', function ( e ) {
        var $btn = $(e.target);
        if (!$btn.hasClass('btn')){
            $btn = $btn.closest('.btn');
        }
        $btn.collection('remove');
        e.preventDefault();
      });
  });

} ( window.jQuery );
