CHANGELOG for 2.5.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.5 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.5.0...v2.5.1

* 2.5.12 (2015-05-27)

 * security #14759 CVE-2015-4050 [HttpKernel] Do not call the FragmentListener if _controller is already defined (jakzal)

* 2.5.11 (2015-04-01)

 * security #14167 CVE-2015-2308 (nicolas-grekas)
 * security #14166 CVE-2015-2309 (neclimdul)

* 2.5.10 (2015-02-02)

 * bug #13528 [Validator] reject ill-formed strings (nicolas-grekas)
 * bug #13525 [Validator] UniqueEntityValidator - invalidValue fixed. (Dawid Sajdak)
 * bug #13549 [EventDispatcher] Wrong EventDispatcher instance injected in listeners (dosten)
 * bug #13527 [Validator] drop grapheme_strlen in LengthValidator (nicolas-grekas)
 * bug #13376 [FrameworkBundle][config] allow multiple fallback locales. (aitboudad)
 * bug #12972 Make the container considered non-fresh if the environment parameters are changed (thewilkybarkid)
 * bug #13309 [Console] fixed 10531 (nacmartin)
 * bug #13352 [Yaml] fixed parse shortcut Key after unindented collection. (aitboudad)
 * bug #13343 [FrameworkBundle] FormDataCollector should be loaded only if form config is enabled (hason)
 * bug #13039 [HttpFoundation] [Request] fix baseUrl parsing to fix wrong path_info (rk3rn3r)
 * bug #13250 [Twig][Bridge][TranslationDefaultDomain] add support of named arguments. (aitboudad)
 * bug #13332 [Console] ArgvInput and empty tokens (Taluu)
 * bug #13293 [EventDispatcher] Add missing checks to RegisterListenersPass (znerol)
 * bug #13262 [Yaml] Improve YAML boolean escaping (petert82, larowlan)
 * bug #13420 [Debug] fix loading order for legacy classes (nicolas-grekas)
 * bug #13421 [FrameworkBundle] fix routing descriptor for options (Tobion)
 * bug #13405 [TwigBridge] exit when Twig environment is not set in the LintCommand (xabbuh)
 * bug #13371 fix missing comma in YamlDumper (garak)
 * bug #13365 [HttpFoundation] Make use of isEmpty() method (xelaris)
 * bug #13355 [Console] Helper\Table->addRow optimization (boekkooi)
 * bug #13347 [Console] Helper\TableHelper->addRow optimization (boekkooi)
 * bug #13346 [PropertyAccessor] Allow null value for a array (2.3) (boekkooi)
 * bug #13170 [Form] Set a child type to text if added to the form without a type. (jakzal)
 * bug #13334 [Yaml] Fixed #10597: Improved Yaml directive parsing (VictoriaQ)
 * bug #13316 [Form] fixed the CSRF extension to allow using only the new interfaces (fabpot)
 * bug #13305 [FrameworkBundle] fixed missing information in some descriptors (fabpot)

* 2.5.9 (2015-01-07)

 * bug #13286 [Security] Don't destroy the session on buggy php releases. (derrabus)
 * bug #12417 [HttpFoundation] Fix an issue caused by php's Bug #66606. (wusuopu)
 * bug #13200 Don't add Accept-Range header on unsafe HTTP requests (jaytaph)
 * bug #12491 [Security] Don't send remember cookie for sub request (blanchonvincent)
 * bug #12574 [HttpKernel] Fix UriSigner::check when _hash is not at the end of the uri (nyroDev)
 * bug #13185 Fixes Issue #13184 - incremental output getters now return empty strings (Bailey Parker)
 * bug #13173 [Debug] fixes ClassNotFoundFatalErrorHandler to correctly handle class not found errors with Symfony ClassLoader component autoloaders. (hhamon)
 * bug #13145 [DomCrawler] Fix behaviour with <base> tag (dkop, WouterJ)
 * bug #13027 fix #10054 - form data collector with dynamic fields (zulus)
 * bug #13141 [TwigBundle] Moved the setting of the default escaping strategy from the Twig engine to the Twig environment (fabpot)
 * bug #13114 [HttpFoundation] fixed error when an IP in the X-Forwarded-For HTTP head... (fabpot)
 * bug #12572 [HttpFoundation] fix checkip6 (Neime)
 * bug #13093 [TwigBundle] added missing absolute URL in Twig exceptions (fabpot)
 * bug #12975 [FrameworkBundle] Allow custom services for validator mapping cache. (jakzal)
 * bug #13075 [Config] fix error handler restoration in test (nicolas-grekas)
 * bug #13085 [FrameworkBundle] Fix dependency on ExtensionInterface over implementation (xphere)
 * bug #13081 [FrameworkBundle] forward error reporting level to insulated Client (nicolas-grekas)
 * bug #13053 [FrameworkBundle] Fixed Translation loader and update translation command. (saro0h)
 * bug #13048 [Security] Delete old session on auth strategy migrate (xelaris)
 * bug #12999 [FrameworkBundle] fix cache:clear command (nicolas-grekas)
 * bug #13004 add a limit and a test to FlattenExceptionTest. (Daniel Wehner)
 * bug #12961 fix session restart on PHP 5.3 (Tobion)
 * bug #12548 [Form] fixed a maxlength overring on a guessing (origaminal)
 * bug #12761 [Filesystem] symlink use RealPath instead LinkTarget (aitboudad)
 * bug #12848 [EventDispatcher] Fixed #12845 adding a listener to an event that is currently being dispatched (Pieter Jordaan)
 * bug #12855 [DependencyInjection] Perf php dumper (nicolas-grekas)
 * bug #12894 [FrameworkBundle][Template name] avoid  error message for the shortcut n... (aitboudad)
 * bug #12806 [Console] Removed the use of $this->getHelperSet() as it is null by default (saro0h)
 * bug #12858 [ClassLoader] Fix undefined index in ClassCollectionLoader (szicsu)

* 2.5.8 (2014-12-03)

 * bug #12811 Configure firewall's kernel exception listener with configured entry point or a default entry point (rjkip)
 * bug #12784 [DependencyInjection] make paths relative to __DIR__ in the generated container (nicolas-grekas)
 * bug #12716 [ClassLoader] define constant only if it wasn't defined before (xabbuh)
 * bug #12553 [Debug] fix error message on double exception (nicolas-grekas)
 * bug #12550 [FrameworkBundle] backport #12489 (xabbuh)
 * bug #12570 Fix initialized() with aliased services (Daniel Wehner)
 * bug #12267 [Form][WebProfiler] Empty form names fix (kix)
 * bug #12137 [FrameworkBundle] cache:clear command fills *.php.meta files with wrong data (Strate)

* 2.5.7 (2014-11-20)

 * bug #12525 [Bundle][FrameworkBundle] be smarter when guessing the document root (xabbuh)
 * bug #12296 [SecurityBundle] Authentication entry point is only registered with firewall exception listener, not with authentication listeners (rjkip)
 * bug #12489 [FrameworkBundle] Fix server run in case the router script does not exist (romainneutron)
 * bug #12443 [HttpKernel] Adding support for invokable controllers in the RequestDataCollector (jameshalsall)
 * bug #12393 [DependencyInjection] inlined factory not referenced (boekkooi)
 * bug #12436 [Filesystem] Fixed case for empty folder (yosmanyga)
 * bug #12397 [Routing] fix BC (nicolas-grekas)
 * bug #12382 [Routing] removed errors from git (HeinZawHtet)
 * bug #12370 [Yaml] improve error message for multiple documents (xabbuh)
 * bug #12170 [Form] fix form handling with OPTIONS request method (Tobion)
 * bug #12235 [Validator] Fixed Regex::getHtmlPattern() to work with complex and negated patterns (webmozart)
 * bug #12326 [Session] remove invalid hack in session regenerate (Tobion)
 * bug #12341 [Kernel] ensure session is saved before sending response (Tobion)
 * bug #12329 [Routing] serialize the compiled route to speed things up (Tobion)
 * bug #12291 [Form] Fixed usage of "name" variable in form_start block (webmozart)
 * bug #12316 Break infinite loop while resolving aliases (chx)
 * bug #12313 [Security][listener] change priority of switchuser (aitboudad)

* 2.5.6 (2014-10-24)

 * bug #11696 [Form] Fix #11694 - Enforce options value type check in some form types (kix)
 * bug #12225 [SecurityBundle] Add trust_resolver variable into expression (zulus)
 * bug #12209 [FrameworkBundle] Fixed ide links (hason)
 * bug #12208 Add missing argument (WouterJ)
 * bug #12197 [TwigBundle] do not pass a template reference to twig (Tobion)
 * bug #12196 [TwigBundle] show correct fallback exception template in debug mode (Tobion)
 * bug #12187 [CssSelector] don't raise warnings when exception is thrown (xabbuh)
 * bug #12151 [Framework][DX] Set the proper validator class according to the configured api version (peterrehm)
 * bug #12128 [Console] clean handling of :: passed to find() (xabbuh)
 * bug #11998 [Intl] Integrated ICU data into Intl component #2 (webmozart)
 * bug #11920 [Intl] Integrated ICU data into Intl component #1 (webmozart)

* 2.5.5 (2014-09-28)

 * bug #12016 [Validator] Added ConstraintValidator::buildViolation() helper for BC with the 2.4 API (webmozart)
 * bug #12031 [Validator] Fixed LegacyValidator when only a constraint is validated (webmozart)
 * bug #9453 [Form][DateTime] Propagate invalid_message & invalid_message_parameters to date & time (egeloen)
 * bug #12030 Fix expression language in the container when using the "container" variable (fabpot)
 * bug #12032 [Command] Set the process title as late as possible (lyrixx)
 * bug #11058 [Security] bug #10242 Missing checkPreAuth from RememberMeAuthenticationProvider (glutamatt)
 * bug #12004 [Form] Fixed ValidatorTypeGuesser to guess properties without constraints not to be required (webmozart)
 * bug #11904 Make twig ExceptionController conformed with ExceptionListener (megazoll)
 * bug #11924 [Form] Moved POST_MAX_SIZE validation from FormValidator to request handler (rpg600, webmozart)
 * bug #12002 [Security] [Firewall] Bug fixed in SimplePreAuthenticationListener when createToken() not return TokenInterface object (adenkejawen, fabpot)
 * bug #11079 Response::isNotModified returns true when If-Modified-Since is later than Last-Modified (skolodyazhnyy)
 * bug #11989 [Finder][Urgent] Remove asterisk and question mark from folder name in test to prevent windows file system issues. (Adam)
 * bug #11908 [Translation] [Config] Clear libxml errors after parsing xliff file (pulzarraider)
 * bug #11839 [FrameworkBundle] check if the Validator component is present when forms are enabled (xabbuh)
 * bug #11418 [JsonResponse] Silent only JSON errors (GromNaN)
 * bug #11937 [HttpKernel] Make sure HttpCache is a trusted proxy (thewilkybarkid)
 * bug #11970 [Finder] Escape location for regex searches (ymc-dabe)
 * bug #11837 Use getPathname() instead of string casting to get BinaryFileReponse file path (nervo)
 * bug #11513 [Translation] made XliffFileDumper support CDATA sections. (hhamon)
 * bug #11928 [Validator] The ratio of the ImageValidator is rounded to two decimals now (webmozart)
 * bug #11907 [Intl] Improved bundle reader implementations (webmozart)
 * bug #11874 [Console] guarded against non-traversable aliases (thierrymarianne)
 * bug #11799 [YAML] fix handling of empty sequence items (xabbuh)
 * bug #11906 [Intl] Fixed a few bugs in TextBundleWriter (webmozart)
 * bug #11459 [Form][Validator] All index items after children are to be considered grand-children when resolving ViolationPath (Andrew Moore)
 * bug #11715 [Form] FormBuilder::getIterator() now deals with resolved children (issei-m)
 * bug #11892 [SwiftmailerBridge] Bump allowed versions of swiftmailer (ymc-dabe)
 * bug #11918 [DependencyInjection] remove `service` parameter type from XSD (xabbuh)
 * bug #11905 [Intl] Removed non-working $fallback argument from ArrayAccessibleResourceBundle (webmozart)
 * bug #11497 Use separated function to resolve command and related arguments (JJK801)
 * bug #11374 [DI] Added safeguards against invalid config in the YamlFileLoader (stof)
 * bug #11897 [FrameworkBundle] Remove invalid markup (flack)
 * bug #11860 [Security] Fix usage of unexistent method in DoctrineAclCache. (mauchede)
 * bug #11850 [YAML] properly mask escape sequences in quoted strings (xabbuh)
 * bug #11856 [FrameworkBundle] backport more error information from 2.6 to 2.3 (xabbuh)
 * bug #11843 [Yaml] improve error message when detecting unquoted asterisks (xabbuh)

* 2.5.4 (2014-09-03)

 * security #11832 CVE-2014-6072 (fabpot)
 * security #11831 CVE-2014-5245 (stof)
 * security #11830 CVE-2014-4931 (aitboudad, Jérémy Derussé)
 * security #11829 CVE-2014-6061 (damz, fabpot)
 * security #11828 CVE-2014-5244 (nicolas-grekas, larowlan)
 * bug #10197 [FrameworkBundle] PhpExtractor bugfix and improvements (mtibben)
 * bug #11772 [Filesystem] Add FTP stream wrapper context option to enable overwrite (Damian Sromek)
 * bug #11791 [Process] fix mustRun() in sigchild environments (xabbuh)
 * bug #11788 [Yaml] fixed mapping keys containing a quoted # (hvt, fabpot)
 * bug #11787 fixed DateComparator if file does not exist (avi123)
 * bug #11160 [DoctrineBridge] Abstract Doctrine Subscribers with tags (merk)
 * bug #11768 [ClassLoader] Add a __call() method to XcacheClassLoader (tstoeckler)
 * bug #11739 [Validator] Pass strict argument into the strict email validator (brianfreytag)
 * bug #11749 [TwigBundle] Remove hard dependency of RequestContext in AssetsExtension (pgodel)
 * bug #11726 [Filesystem Component] mkdir race condition fix #11626 (kcassam)
 * bug #11677 [YAML] resolve variables in inlined YAML (xabbuh)
 * bug #11639 [DependencyInjection] Fixed factory service not within the ServiceReferenceGraph. (boekkooi)
 * bug #11778 [Validator] Fixed wrong translations for Collection constraints (samicemalone)
 * bug #11756 [DependencyInjection] fix @return anno created by PhpDumper (jakubkulhan)
 * bug #11711 [DoctrineBridge] Fix empty parameter logging in the dbal logger (jakzal)
 * bug #11692 [DomCrawler] check for the correct field type (xabbuh)
 * bug #11672 [Routing] fix handling of nullable XML attributes (xabbuh)
 * bug #11624 [DomCrawler] fix the axes handling in a bc way (xabbuh)
 * bug #11676 [Form] Fixed #11675 ValueToDuplicatesTransformer accept "0" value (Nek-)
 * bug #11695 [Validators] Fixed failing tests requiring ICU 52.1 which are skipped otherwise (webmozart)
 * bug #11584 [FrameworkBundle] Fixed validator factory definition when the Validator API is "auto" for PHP < 5.3.9 (webmozart)
 * bug #11645 [Form] Fixed ValidatorExtension to work with the 2.5 Validation API (webmozart)
 * bug #11529 [WebProfilerBundle] Fixed double height of canvas (hason)
 * bug #11666 [DIC] Fixed: anonymous services are always private (lyrixx)
 * bug #11641 [WebProfilerBundle ] Fix toolbar vertical alignment (blaugueux)
 * bug #11637 fix dependencies on HttpFoundation component (xabbuh)
 * bug #11559 [Validator] Convert objects to string in comparison validators (webmozart)
 * feature #11510 [HttpFoundation] MongoDbSessionHandler supports auto expiry via configurable expiry_field (catchamonkey)
 * bug #11408 [HttpFoundation] Update QUERY_STRING when overrideGlobals (yguedidi)
 * bug #11625 [FrameworkBundle] resolve parameters before the configs are processed in the config:debug command (xabbuh)
 * bug #11633 [FrameworkBundle] add missing attribute to XSD (xabbuh)
 * bug #11601 [Validator] Allow basic auth in url when using UrlValidator. (blaugueux)
 * bug #11609 [Console] fixed style creation when providing an unknown tag option (fabpot)
 * bug #10914 [HttpKernel] added an analyze of environment parameters for built-in server (mauchede)
 * bug #11598 [Finder] Shell escape and windows support (Gordon Franke, gimler)
 * bug #11582 [DoctrineBridge] Changed UniqueEntityValidator to use the 2.5 Validation API (webmozart)

* 2.5.3 (2014-08-06)

 * bug #11571 [Form] Fixed FormValidator compatibility with the non-BC 2.5 Validation API (webmozart)
 * bug #11499 [BrowserKit] Fixed relative redirects for ambiguous paths (pkruithof)
 * bug #11516 [BrowserKit] Fix browser kit redirect with ports (dakota)
 * bug #11545 [Bundle][FrameworkBundle] built-in server: exit when docroot does not exist (xabbuh)
 * bug #11560 Plural fix (1emming)
 * bug #11558 [DependencyInjection] Fixed missing 'factory-class' attribute in XmlDumper output (kerdany)
 * bug #11498 [Validator] Made it possible (again) to pass a class name to validatePropertyValue() (webmozart)
 * bug #11548 [Component][DomCrawler] fix axes handling in Crawler::filterXPath() (xabbuh)
 * bug #11422 [DependencyInjection] Self-referenced 'service_container' service breaks garbage collection (sun)
 * bug #11428 [Serializer] properly handle null data when denormalizing (xabbuh)
 * bug #10687 [Validator] Fixed string conversion in constraint violations (eagleoneraptor, webmozart)
 * bug #11412 [Validator] Made sure that context changes don't leak out of (Contextual)ValidatorInterface (webmozart)
 * bug #11475 [EventDispatcher] don't count empty listeners (xabbuh)
 * bug #11436 fix signal handling in wait() on calls to stop() (xabbuh, romainneutron)
 * bug #11469  [BrowserKit] Fixed server HTTP_HOST port uri conversion (bcremer, fabpot)
 * bug #11425 Fix issue described in #11421 (Ben, ben-rosio)
 * bug #11423 Pass a Scope instance instead of a scope name when cloning a container in the GrahpvizDumper (jakzal)
 * bug #11448 [MonologBridge] fixed Console handler priorities (fabpot)
 * bug #11454 [Validator] Fixed memory leak in ValidatorBuilder (webmozart)
 * bug #11120 [Process] Reduce I/O load on Windows platform (romainneutron)
 * bug #11370 [FrameworkBundle] avoid raising unexpected RuntimeException when specifying $_SERVER['KERNEL_DIR'] (iteman)
 * bug #11342 [Form] Check if IntlDateFormatter constructor returned a valid object before using it (romainneutron)
 * bug #11439 [ExpressionLanguage] Fixed double quoted string literals containing sharps (pylebecq)
 * bug #11410 [Validator] Fixed object initializers in 2.5 version of the Validator (webmozart)
 * bug #11411 [Validator] Backported #11410 to 2.3: Object initializers are called only once per object (webmozart)
 * bug #11403 [Translator][FrameworkBundle] Added @ to the list of allowed chars in Translator (takeit)
 * bug #11381  [Process] Use correct test for empty string in UnixPipes (whs, romainneutron)

* 2.5.2 (2014-07-15)

 * [Security] Forced validate of locales passed to the translator
 * bug #11350 [Form] solved dependency to ValidatorInterface, fix #11036 (Sebastian Blum)
 * bug #11278 Remove Spaceless Blocks From Twig Templates (chrisguitarguy)
 * feature #11367 [HttpFoundation] Fix to prevent magic bytes injection in JSONP responses... (CVE-2014-4671) (Andrew Moore)
 * bug #11284 [Console] Remove estimated field from debug_nomax (bburnichon)
 * bug #11386 Remove Spaceless Blocks from Twig Form Templates (chrisguitarguy)
 * bug #9719 [TwigBundle] fix configuration tree for paths (mdavis1982, cordoval)
 * bug #11244 [HttpFoundation] Remove body-related headers when sending the response, if body is empty (SimonSimCity)

* 2.5.1 (2014-07-08)

 * bug #11283 [SecurityBundle] Remove Expression Language services when the component is unavailable (thewilkybarkid)
 * bug #11238 [Translation] Added unescaping of ids in PoFileLoader (JustBlackBird)
 * bug #11194 [DomCrawler] Remove the query string and the anchor of the uri of a link (benja-M-1)
 * bug #11272 [Console] Make sure formatter is the same. (akimsko)
 * bug #11259 [Config] Fixed failed config schema loads due to libxml_disable_entity_loader usage (ccorliss)
 * bug #11234 [ClassLoader] fixed PHP warning on PHP 5.3 (fabpot)
 * bug #11179 [Process] Fix ExecutableFinder with open basedir (cs278)
 * bug #11242 [CssSelector] Refactored the CssSelector to remove the circular object graph (stof)
 * bug #11219 [DomCrawler] properly handle buttons with single and double quotes insid... (xabbuh)
 * bug #11220 [Components][Serializer] optional constructor arguments can be omitted during the denormalization process (xabbuh)
 * bug #11186 Added missing `break` statement (apfelbox)
 * bug #11168 [YAML] fix merge node (<<) (Tobion)
 * bug #11170 [Console] Fixed notice in QuestionHelper (florianv)
 * bug #11169 [Console] Fixed notice in DialogHelper (florianv)
 * bug #11144 [HttpFoundation] Fixed Request::getPort returns incorrect value under IPv6 (kicken)
 * bug #11121 [Process] Do not redirect output to file handles when output is disabled, simply discard it (romainneutron)
 * bug #10966 PHP Fatal error when getContainer method of ContainerAwareCommand has be... (kevinvergauwen)
 * bug #10981 [HttpFoundation] Fixed isSecure() check to be compliant with the docs (Jannik Zschiesche)
 * bug #11117 [Validator] Fix array notation in the PropertyPath::append() (jakzal)
 * bug #11113 [HttpKernel] Fix event dispatcher dependency (hacfi)
 * bug #11111 Fixed undefined ImageValidator::$suffices property when uploading an image during functional tests (OwlyCode)
 * bug #11099 [Debug] work-around https://bugs.php.net/61272 (nicolas-grekas)
 * bug #11092 [HttpFoundation] Fix basic authentication in url with PHP-FPM (Kdecherf)
 * bug #11097 [Debug] simplify code path to remove potential blank pages (nicolas-grekas)
 * bug #10808 [DomCrawler] Empty select with attribute name="foo[]" bug fix (darles)
 * bug #11063 [HttpFoundation] fix switch statement (Tobion)
 * bug #11054 [Serializer] Xml encoder whitespace fix (fieg)
 * bug #11009 [HttpFoundation] smaller fixes for PdoSessionHandler (Tobion)
 * bug #11047 #10862 loadClassMetadata vs loadValidatorMetadata: revert default config (phramz)
 * bug #11042 [Debug] fix debug handlers config (nicolas-grekas)
 * bug #11043 [Console] OutputFormatter Unset Bold has wrong id (DZunke)
 * bug #11033 [Debug] fix wrong case mismatch exception (nicolas-grekas)
 * bug #11044 [Serializer] Fix BC break since 2.5 (fieg)
 * bug #11041 Remove undefined variable $e (skydiablo)

* 2.5.0 (2014-05-31)

 * bug #11014 [Validator] Remove property and method targets from the optional and required constraints (jakzal)
 * bug #10983 [DomCrawler] Fixed charset detection in html5 meta charset tag (77web)

* 2.5.0-RC1 (2014-05-28)

 * bug #10979 Make rootPath part of regex greedy (artursvonda)
 * bug #10995 [TwigBridge][Trans]set %count% only on transChoice from the current context. (aitboudad)
 * bug #10989 [Debug] throw even in stacking mode to preserve code paths (nicolas-grekas)
 * bug #10987 [DomCrawler] Fixed a forgotten case of complex XPath queries (stof)
 * feature #10930 [Process] Deprecate using values that are not string for Process::setStdin and ProcessBuilder::setInput (romainneutron)
 * bug #10971 [Process] Fix conflicts between latest 2.3 fix and 2.5 deprecation (romainneutron)
 * feature #10932 [Process] Deprecate Process::setStdin in favor of Process::setInput (romainneutron)
 * bug #10849 [WIP][Finder] Fix wrong implementation on sortable callback comparator (ProPheT777)
 * bug #10929 [Process] Add validation on Process input (romainneutron)
 * bug #10946 [PropertyAccess] Fixed getValue() when accessing non-existing indices of ArrayAccess implementations (webmozart)
 * bug #10958 [DomCrawler] Fixed filterXPath() chaining loosing the parent DOM nodes (stof, robbertkl)
 * bug #10953 [HttpKernel] fixed file uploads in functional tests without file selected (realmfoo)
 * feature #10941 [Debug] cleanup interfaces before 2.5-final (nicolas-grekas)
 * bug #10947 [PropertyAccess] Fixed getValue() when accessing non-existing indices of ArrayAccess implementations (webmozart)
 * bug #10937 [HttpKernel] Fix "absolute path" when we look to the cache directory (BenoitLeveque)
 * bug #10933 Changed the default value of checkbox and radio to match the HTML spec (stof)
 * bug #10927 [DomCrawler] Changed typehints form DomNode to DomElement (stof)
 * bug #10894 [HttpKernel] removed absolute paths from the generated container (fabpot)
 * bug #10926 [DomCrawler] Fixed the initial state for options without value attribute (stof)
 * bug #10925 [DomCrawler] Fixed the handling of boolean attributes in ChoiceFormField (stof)
 * feature #10882 Fix issue #10867 (umpirsky)
 * bug #10902 [Yaml] Fixed YAML Parser does not ignore duplicate keys, violating YAML spec. (sun)
 * feature #10912 [Form] Added support for injecting HttpFoundation's Request in ServerParams for the Validator extension (csarrazi)
 * bug #10777 [Form] Automatically add step attribute to HTML5 time widgets to display seconds if needed (tucksaun)
 * bug #10909 [PropertyAccess] Fixed plurals for -ves words (csarrazi)
 * bug #10904 [HttpKernel] Replace sha1 with sha256 in recently added tests (jakzal)
 * bug #10899 Explicitly define the encoding. (jakzal)
 * bug #10897 [Console] Fix a console test (jakzal)
 * bug #10896 [HttpKernel] Fixed cache behavior when TTL has expired and a default "global" TTL is defined (alquerci, fabpot)
 * bug #10841 [DomCrawler] Fixed image input case sensitive (geoffrey-brier)
 * bug #10714 [Console]Improve formatter for double-width character (denkiryokuhatsuden)
 * bug #10872 [Form] Fixed TrimListenerTest as of PHP 5.5 (webmozart)
 * feature #10880 [DependencyInjection] GraphvizDumper now displays unresolved parameters (rosstuck)
 * bug #10876 [Console] Make `Helper\Table::setStyle()` chainable again (stloyd)
 * bug #10762 [BrowserKit] Allow URLs that don't contain a path when creating a cookie from a string (thewilkybarkid)
 * bug #10861 [Debug] enhance perf of DebugClassLoader (nicolas-grekas)
 * bug #10863 [Security] Add check for supported attributes in AclVoter (artursvonda)
 * bug #10854 [Debug] fix handling deprecated warnings and stacked errors turned into exceptions (nicolas-grekas)
 * feature #10843 [TwigBridge] Added compile-time issues checking in twig:lint command (maxromanovsky)
 * feature #10829 Fix issue 9172 (umpirsky)
 * bug #10833 [TwigBridge][Transchoice] set %count% from the current context. (aitboudad)
 * bug #10820 [WebProfilerBundle] Fixed profiler seach/homepage with empty token (tucksaun)
 * bug #10809 Fixed composer to include config component for mocks in phpunit (jpauli)
 * bug #10815 Fixed issue #5427 (umpirsky)
 * bug #10817 [Debug] fix #10313: FlattenException not found (nicolas-grekas)

* 2.5.0-BETA2 (2014-04-29)

 * bug #10803 [Debug] fix ErrorHandlerTest when context is not an array (nicolas-grekas)
 * bug #10801 [Debug] ErrorHandler: remove $GLOBALS from context in PHP5.3 fix #10292 (nicolas-grekas)
 * bug #10799 [Debug] less intrusive work around for https://bugs.php.net/54275 (nicolas-grekas)
 * bug #10797 [HttpFoundation] Allow File instance to be passed to BinaryFileResponse (anlutro)
 * bug #10798 [Console] Fix #10795: Allow instancing Console Application when STDIN is not declared (romainneutron)
 * bug #10643 [TwigBridge] Removed strict check when found variables inside a translation (goetas)
 * bug #10605 [ExpressionLanguage] Strict in_array check in Parser.php (parnas)
 * bug #10789 [Console] Fixed the rendering of exceptions on HHVM with a terminal width (stof)
 * bug #10773 [WebProfilerBundle ] Fixed an edge case on WDT loading (tucksaun)
 * feature #10786 [FrameworkBundle] removed support for HHVM built-in web server as it is deprecated now (fabpot)
 * bug #10784 [Security] removed $csrfTokenManager type hint from SimpleFormAuthenticationListener constructor argument (choonge)
 * bug #10776 [Debug] fix #10771 DebugClassLoader can't load PSR4 libs (nicolas-grekas)
 * bug #10763 [Process] Disable TTY mode on Windows platform (romainneutron)
 * bug #10772 [Finder] Fix ignoring of unreadable dirs in the RecursiveDirectoryIterator (jakzal)
 * bug #10757 [Process] Setting STDIN while running should not be possible (romainneutron)
 * bug #10749 Fixed incompatibility of x509 auth with nginx (alcaeus)
 * feature #10725 [Debug] Handled errors (nicolas-grekas)
 * bug #10735 [Translation] [PluralizationRules] Little correction for case 'ar' (klyk50)
 * bug #10720 [HttpFoundation] Fix DbalSessionHandler  (Tobion)
 * bug #10721 [HttpFoundation] status 201 is allowed to have a body (Tobion)
 * bug #10728 [Process] Fix #10681, process are failing on Windows Server 2003 (romainneutron)
 * bug #10733 [DomCrawler] Textarea value should default to empty string instead of null. (Berdir)
 * bug #10723 [Security] fix DBAL connection typehint (Tobion)
 * bug #10715 [Debug] Fixed ClassNotFoundFatalErrorHandler on windows. (lyrixx)
 * bug #10700 Fixes various inconsistencies in the code (fabpot)
 * bug #10697 [Translation] Make IcuDatFileLoader/IcuResFileLoader::load invalid resource compatible with HHVM. (idn2104)

* 2.5.0-BETA1 (2014-04-11)

 * first beta release

