CREATE TABLE ArticleAttachment (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, path VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, remote TINYINT(1) NOT NULL, idext VARCHAR(255) DEFAULT NULL, orientation VARCHAR(255) NOT NULL, articleBody_id INT NOT NULL, INDEX IDX_8F0819A81717D737 (reader_id), INDEX IDX_8F0819A8C72B541B (articleBody_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE ArticleBody (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, idext VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, body LONGTEXT DEFAULT NULL, author VARCHAR(255) NOT NULL, date DATETIME NOT NULL, version DOUBLE PRECISION NOT NULL, enableComments TINYINT(1) NOT NULL, INDEX IDX_227211DB1717D737 (reader_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE ArticleTags (id INT AUTO_INCREMENT NOT NULL, tagName VARCHAR(255) NOT NULL, articleBody_id INT NOT NULL, INDEX IDX_96668E4FC72B541B (articleBody_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE App (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, theme VARCHAR(255) NOT NULL, version LONGTEXT NOT NULL, packageName VARCHAR(255) NOT NULL, description LONGTEXT NOT NULL, author VARCHAR(255) NOT NULL, website VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, debugMode TINYINT(1) NOT NULL, configPackages LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)', preferences LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)', PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Gadget (id INT AUTO_INCREMENT NOT NULL, page_id INT NOT NULL, name VARCHAR(255) NOT NULL, shared TINYINT(1) NOT NULL, zone VARCHAR(255) NOT NULL, config LONGTEXT NOT NULL COMMENT '(DC2Type:array)', template VARCHAR(255) NOT NULL, INDEX IDX_B1F352BCC4663E4 (page_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Page (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, isMain TINYINT(1) NOT NULL, appId INT NOT NULL, icon VARCHAR(255) NOT NULL, templateId VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Reader (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, service VARCHAR(255) NOT NULL, config LONGTEXT NOT NULL COMMENT '(DC2Type:array)', allowupdate TINYINT(1) DEFAULT NULL, linkedEntity VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Theme (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE fos_user (id INT AUTO_INCREMENT NOT NULL, username VARCHAR(255) NOT NULL, username_canonical VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, email_canonical VARCHAR(255) NOT NULL, enabled TINYINT(1) NOT NULL, salt VARCHAR(255) NOT NULL, password VARCHAR(255) NOT NULL, last_login DATETIME DEFAULT NULL, locked TINYINT(1) NOT NULL, expired TINYINT(1) NOT NULL, expires_at DATETIME DEFAULT NULL, confirmation_token VARCHAR(255) DEFAULT NULL, password_requested_at DATETIME DEFAULT NULL, roles LONGTEXT NOT NULL COMMENT '(DC2Type:array)', credentials_expired TINYINT(1) NOT NULL, credentials_expire_at DATETIME DEFAULT NULL, accountType VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_957A647992FC23A8 (username_canonical), UNIQUE INDEX UNIQ_957A6479A0D96FBF (email_canonical), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Location (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT NOT NULL, lat DOUBLE PRECISION NOT NULL, lng DOUBLE PRECISION NOT NULL, enableComments TINYINT(1) NOT NULL, INDEX IDX_A7E8EB9D1717D737 (reader_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE LocationTags (id INT AUTO_INCREMENT NOT NULL, tagName VARCHAR(255) NOT NULL, Location_id INT NOT NULL, INDEX IDX_FB06728F80D1AE59 (Location_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Picture (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, path VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT NOT NULL, idext VARCHAR(255) NOT NULL, enableComments TINYINT(1) NOT NULL, orientation VARCHAR(255) NOT NULL, INDEX IDX_D96676151717D737 (reader_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE pictureTag (id INT AUTO_INCREMENT NOT NULL, picture_id INT NOT NULL, tagName VARCHAR(255) NOT NULL, INDEX IDX_B3C089ECEE45BDBF (picture_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE PictureTags (id INT AUTO_INCREMENT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Event (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, date DATETIME NOT NULL, description LONGTEXT NOT NULL, location VARCHAR(255) NOT NULL, latitude DOUBLE PRECISION NOT NULL, longitude DOUBLE PRECISION NOT NULL, enableComments TINYINT(1) NOT NULL, INDEX IDX_FA6F25A31717D737 (reader_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Comment (id INT AUTO_INCREMENT NOT NULL, reader_id INT DEFAULT NULL, user_id INT DEFAULT NULL, message LONGTEXT NOT NULL, date DATETIME NOT NULL, idDataModel INT NOT NULL, dataModelObject VARCHAR(255) NOT NULL, INDEX IDX_5BC96BF01717D737 (reader_id), INDEX IDX_5BC96BF0A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE Devices (id INT AUTO_INCREMENT NOT NULL, type INT NOT NULL, token LONGTEXT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
ALTER TABLE ArticleAttachment ADD CONSTRAINT FK_8F0819A81717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE ArticleAttachment ADD CONSTRAINT FK_8F0819A8C72B541B FOREIGN KEY (articleBody_id) REFERENCES ArticleBody (id);
ALTER TABLE ArticleBody ADD CONSTRAINT FK_227211DB1717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE ArticleTags ADD CONSTRAINT FK_96668E4FC72B541B FOREIGN KEY (articleBody_id) REFERENCES ArticleBody (id);
ALTER TABLE Gadget ADD CONSTRAINT FK_B1F352BCC4663E4 FOREIGN KEY (page_id) REFERENCES Page (id);
ALTER TABLE Location ADD CONSTRAINT FK_A7E8EB9D1717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE LocationTags ADD CONSTRAINT FK_FB06728F80D1AE59 FOREIGN KEY (Location_id) REFERENCES Location (id);
ALTER TABLE Picture ADD CONSTRAINT FK_D96676151717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE pictureTag ADD CONSTRAINT FK_B3C089ECEE45BDBF FOREIGN KEY (picture_id) REFERENCES Picture (id);
ALTER TABLE Event ADD CONSTRAINT FK_FA6F25A31717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE Comment ADD CONSTRAINT FK_5BC96BF01717D737 FOREIGN KEY (reader_id) REFERENCES Reader (id);
ALTER TABLE Comment ADD CONSTRAINT FK_5BC96BF0A76ED395 FOREIGN KEY (user_id) REFERENCES fos_user (id);